#include <bits/stdc++.h>
using namespace std;
#define int long long
#define P array<int,2>
const int MAXN = 1e5+5;


int n;
vector<P> a;

int area(P a, P b, P c){
	int p = abs(a[0]*(b[1]-c[1])+b[0]*(c[1]-a[1])+c[0]*(a[1]-b[1]))/2;
	return p;
}
int area(vector<P> &a, vector<int> &d){
	int p = 0;
	for(int i = 2; i < d.size(); ++i){
		p += area(a[d[0]], a[d[i-1]], a[d[i]]);
	}
	return p;
}
int cross(P O, P A, P B){
    return (A[0] - O[0]) * (B[1] - O[1]) - (A[1] - O[1]) * (B[0] - O[0]);
}


vector<int> upperHull(vector<P> &a){
	if(a.size()==2) return {0,1};
	vector<int> hull{0,1};
	int k=2;
	for(int i = 2; i < a.size(); ++i){
		while(k >= 2 && cross(a[hull[k-2]], a[i], a[hull[k-1]]) <= 0){
			--k;
			hull.pop_back();
		}
		++k;
		hull.push_back(i);
	}
	return hull;
}

vector<int> lowerHull(vector<P> &a){
	vector<int> hull{(int)a.size()-1, (int)a.size()-2};
	if(a.size()==2) return hull;
	int k=2;
	for(int i = a.size()-3; i >= 0; --i){
		while(k >= 2 && cross(a[hull[k-2]], a[i], a[hull[k-1]]) <= 0){
			--k;
			hull.pop_back();
		}
		++k;
		hull.push_back(i);
	}
	return hull;
}

vector<int> convexHull(vector<P> &a){
	vector<int> up = upperHull(a);
	vector<int> low = lowerHull(a);
	up.pop_back();
	low.pop_back();
	for(int k : low) up.push_back(k);
	return up;
}

void solve(){
	cin >> n;
	a.resize(n);
	for(int i = 0; i < n; ++i){
		cin >> a[i][0] >> a[i][1];
	}
	sort(a.begin(), a.end());
	vector<int> hull = convexHull(a);
	//for(auto k : hull) cout << k << ' ' ; cout << '\n';
	int p = area(a, hull);
	auto b = a;
	b.pop_back();
	hull = convexHull(b);
	int r = area(b, hull);
	//cout << "r: " << r << '\n';
	b = a;
	b.erase(b.begin());
	hull = convexHull(b);
	r = min(r, area(b, hull));
	//cout << "r: " << r << '\n';
	vector<int> up = upperHull(a);
	for(int i = 1; i < up.size()-1; ++i){
		vector<P> c;
		for(int j = up[i-1]; j <= up[i+1]; ++j){
			if(j != up[i]) c.push_back(a[j]);
		}
		hull = upperHull(c);
		r = min(r, p-area(a[up[i-1]], a[up[i]], a[up[i+1]])+area(c, hull));
	}
	vector<int> low = lowerHull(a);
	for(int i = low.size()-2; i > 0; --i){
		vector<P> c;
		for(int j = low[i+1]; j <= low[i-1]; ++j){
			if(j != low[i]) c.push_back(a[j]);
		}
		hull = lowerHull(c);
		r = min(r, p-area(a[low[i-1]], a[low[i]], a[low[i+1]])+area(c, hull));
	}
	cout << r << '\n';
}

int32_t main(){
	ios_base::sync_with_stdio(0); cin.tie(0);
	int qqq=1;
	//cin>>qqq;
	while(qqq--)solve();
	return 0;
}